#include "otp_corec32.h"
#include <time.h>
#include <stdio.h>
#ifdef MD_RELEASE
#pragma comment(lib, "otp_srvapi_vc6_MD.lib")
#else
#ifdef MT_RELEASE
#pragma comment(lib, "otp_srvapi_vc6_MT.lib")
#endif
#endif

#ifndef NULL
#define NULL 0
#endif
int main()
{
	unsigned char text[8] = {0};
	unsigned int nchallenge;
	char pszpwd[6];
	char sztime[MAX_DATEBUF_LEN+1] = {0};
	time_t lt;
	struct tm *tm1, *tm2;
	char psztm[30] = {0};
	//you should change it to your token file path
	char sztar[] = "C:\\tktest.uinf";
	char szuser[] = "C:\\usertest.uinf";//user item file
	int ret = secuotp_initenv("C:\\Program Files\\UniOTP\\config\\otp_conf.con");
    char *pserr = NULL;
	int i = 0;
    char *pszerr;
    char szusername[30];
    char szotppin[30];
    char szotp1[30];
    char szotp2[30];
    printf("\n******Authentication test******\n");
    fflush(0);
    printf("Please input the UniOTP username:");
    scanf("%s", szusername);
    printf("Please input the OTP[PIN]:");
    fflush(0);
    scanf("%s", szotppin);

    if(SECUOTP_ERROR_SUCCESS == secuotp_auth(szusername, szotppin, &nchallenge))
    {
        printf("auth successfully!\n");
    }
    else
    {
        printf("auth failed!\n");
    }
    
    printf("\n******Synchronize test******\n");
    fflush(0);
    printf("Please input the UniOTP username for UniOTP synchronize:");
    scanf("%s", szusername);
    
    printf("Please input a OTP:");
    fflush(0);
    scanf("%s", szotp1);
    printf("Please input a second OTP:");
    fflush(0);
    scanf("%s", szotp2);

    if(SECUOTP_ERROR_SUCCESS == (ret=secuotp_synchronize(szusername, szotp1, szotp2)))
    {
        printf("synchronize successfully\n");
    }
    else
    {
        printf("synchronize failed\n");
	}
    
    printf("\n******Tokenimport test******\n");

    ret = secuotp_tokenimport(sztar, "1q2w3e4r5t6y7u8i", &pszerr);
    if (SECUOTP_ERROR_SUCCESS != ret)
    {
        printf("token import failed.Error information:\n%s", pszerr);
    }
    //call secuotp_free to safe free buffer allocated in the interal of API
    secuotp_free(&pszerr);
    printf("\n******Rebind test******\n");
	ret = secuotp_rebind("test", "secu2011053101");
	if (SECUOTP_ERROR_SUCCESS == ret)
	{
		printf("rebind user successfully!\n");
	}
	else
	{
		printf("rebind user failed.#Error code:%d\n", ret);
	}
	// userimport
    printf("\n****User import test******\n");
    ret = secuotp_userimport(sztar, "1234567890123456", &pserr);
    if(SECUOTP_ERROR_SUCCESS_WITHINFO == ret)
    {//some items are not imported successfully
        if (pserr)
        {
			printf("%s\n", pserr);
            secuotp_free(&pserr);
            pserr = NULL;
        }
    }
    else if (SECUOTP_ERROR_SUCCESS != ret)
    {
        printf("user import failed.#Errorcode:%d\n", ret);
    }

	//makelog test	
	if (SECUOTP_ERROR_SUCCESS == secuotp_makelog(10, NULL, 23, "makelog test here!", "192.168.1.211"))
	{
		printf("make log successfully!\n");
	}
	else
	{
		printf("make log failed!\n");
	}
	//token delete
	if (SECUOTP_ERROR_SUCCESS == secuotp_tokendelete("1000000007"))
	{
		printf("delete token successfully!\n");
	}
	else
	{
		printf("delete token failed!\n");
	}
	if (SECUOTP_ERROR_SUCCESS == secuotp_adduser("test2", "123456789098", "15947115102", "1000000008", NULL, "test@gmail.com", NULL, "hello world", NULL, 2))
	{
		printf("add user successfully!\n");
	}
	else
	{
		printf("add user failed!\n");
	}
	//set user lock status
	if (SECUOTP_ERROR_SUCCESS == secuotp_setuserlock("test2", 0))
	{
		printf("user lock successfully!\n");
	}
	else
	{
		printf("user lock failed!\n");
	}
	//set user valid status
	if (SECUOTP_ERROR_SUCCESS == secuotp_setuserinvalid("test2", 0))
	{
		printf("set user invalid success!\n");
	}
	else
	{
		printf("set user invalid failed!\n");
	}
	//set authentication type 1-OTP only 2-OTP[PIN]
	if (SECUOTP_ERROR_INVALID_AUTHTYPE == secuotp_setauthtype("test2", 2))
	{
		printf("invalid auth type!\n");
	}
	else
	{
		printf("change authtype failed!\n");
	}
	//set pin
	if (SECUOTP_ERROR_SUCCESS == secuotp_setuserpin("test2", "123456"))
	{
		printf("update pin successfully!\n");
	}
	else
	{
		printf("update pin failed!\n");
	}
	//reset pin
	if (SECUOTP_ERROR_SUCCESS == secuotp_resetpin("test2", "123456", "234567"))
	{
		printf("reset pin successfully!\n");
	}
	else
	{
		printf("reset pin failed!\n");
	}
	//delete user
	if (SECUOTP_ERROR_SUCCESS == secuotp_deleteuser("test2"))
	{
		printf("delete user success!\n");
	}
	else
	{
		printf("delete user failed!\n");
	}
	if (SECUOTP_ERROR_SUCCESS == secuotp_cleanup())
	{
		printf("Clean up successfully!\n");
	}
	else
	{
		printf("Clean up failed!\n");
	}
	return 0;
}